#


library(readxl)
library(ggplot2)

# **********************************************************************************
# data
# **********************************************************************************

# Home PC
setwd("G:/Google Drive/PhD/Project #1_Characterisation of LOTR1/PI uptake")

# Laptop
#setwd("C:/Users/Andreas Kolbeck/Google Drive/PhD/Project #1_Characterisation of LOTR1/PI uptake")


lotr1_PI <- read_excel("20170314_PI penetrance_forR.xlsx", col_types = c("numeric", "text"))

lotr1_PI_new <- lotr1_PI


lotr1_PI_new$Genotype <- factor(lotr1_PI_new$Genotype,        # changing order of genotypes in plots
                                
                                levels = c("CASP1GFP", "lotr1-1", "sgn1-2", "lotr1-1 sgn1-2","sgn3-3", "lotr1-1 sgn3-3", "esb1-1", "lotr1-1 esb1-1")
)  


# **********************************************************************************
# Plots
# **********************************************************************************
# ------------------------------------
# Boxplot
# ------------------------------------

# ------------------------------------
# ggplots
# ------------------------------------

p1 <- ggplot(lotr1_PI_new, aes(x=Genotype, y = Cells))+
  geom_boxplot()+
  xlab("")+
  #ylim(0,120)+
  ylab("Endodermal cells after onset of elongation")+
  xlab("Genotype")+
  #labs(title = "PI Block")+
  theme_classic()+
  theme(axis.text.x = element_text(color = "black", size = 12, angle = 45, hjust = .5, vjust = .5, face = "plain"),
                axis.text.y = element_text(color = "black", size = 12, angle = 0, hjust = .5, vjust = 0.5, face = "plain"),  
                axis.title.x = element_text(color = "black", size = 14, angle = 0, hjust = 0.5, vjust = 0, face = "plain"),
                axis.title.y = element_text(color = "black", size = 14, angle = 90, hjust = .5, vjust = 1.5, face = "plain"))+
  #scale_x_continuous(expand = c(0, 0), limits = c(0, 150)) + 
  scale_y_continuous(expand = c(0, 0), limits = c(0, 120))

p1 + annotate("text", x = 1:8, y = c(25,55,55,55,115,115,55,55), label = c("a","b","b","b","c","c","b","b"), size=5)


# Save plot as PDF file
pdf("20170314_PI uptake mutants.pdf", useDingbats=FALSE, width=8, height=5)
p1 + annotate("text", x = 1:8, y = c(25,55,55,55,115,115,55,55), label = c("a","b","b","b","c","c","b","b"), size=5)
dev.off()

# **********************************************************************************
# Statistics
# **********************************************************************************
library(agricolae)


# Anova
results <- aov(Cells~Genotype,
                       data = lotr1_PI_new)

summary(results)
#
HSD.test(results, "Genotype", group=TRUE, console=TRUE,      # 
         alpha = 0.001                                       # increase significance level
)


# Linear regression analysis
model <- lm(data = lotr1_PI_new, Cells ~ Genotype)
summary(model)

coefficients(model)
confint(model, level=0.95)
residuals(model)
plot(residuals(model))
anova(model)
influence(model)


#layout(matrix(c(1,2,3,4),2,2)) # optional 4 graphs/page
plot(model)


# 
pdf("20170314_PI_uptake_mutants_d.pdf", useDingbats = FALSE,width = 9, height = 6)
#
boxplot(Cells~Genotype , data = lotr1_PI_new,
        at=c(1,2,4,5,7,8,10,11),
        par(cex = 1.5, mar = c(4, 3.5, 0, 0)+ 0.2, fg = '#f2f2f2', bg = '#212121'),
        col.axis = '#FFFFFF',
        medcol = c("black"),
        names = c(rep(c(""),8)),
        col = c("white", "darkgrey"),
        las = 2,
        ylim = c(0,120),
        xlab = "",
        ylab = ""
        )

mtext("Genotype", side = 1, line = 3, at = 6, cex = 1.5, font =1)
mtext("Cells after onset of elongation", side = 2, line = 2.5, at = 60, cex = 1.5, font = 1)

text(cex=1, x=1, y = -20, "wildtype", xpd=TRUE, srt=30)
text(cex=1, x=2, y = -20, "lotr1", xpd=TRUE, srt=30, font = 3)
text(cex=1, x=4, y = -20, "sgn1", xpd=TRUE, srt=30, font = 3)
text(cex=1, x=5, y = -20, "sgn1 lotr1", xpd=TRUE, srt=30, font = 3)
text(cex=1, x=7, y = -20, "sgn3", xpd=TRUE, srt=30, font = 3)
text(cex=1, x=8, y = -20, "sgn3 lotr1", xpd=TRUE, srt=30, font = 3)
text(cex=1, x=10, y = -20, "esb1", xpd=TRUE, srt=30, font = 3)
text(cex=1, x=11, y = -20, "esb1 lotr1", xpd=TRUE, srt=30, font = 3)


# ***********************************************************************
dev.off()
